% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mountaingoat.R
\docType{data}
\name{mountaingoat}
\alias{mountaingoat}
\title{mountaingoat Bayesian Network}
\format{
A discrete Bayesian network to predict the suitability of habitats for mountain goats. Probabilities were given within the referenced paper. The vertices are:
\describe{
\item{Distance_Escape_Terrain}{(On Escape Terrain, <=150m away, <=300m away, >300m away);}
\item{Elevation}{(<=500m, <=900m, <=1300m, <=1700m, >1700m);}
\item{Forest_Age_Class}{(Early, Mid, Mature, Old, Non-Forested);}
\item{Location}{(Observations, Random));}
\item{Slope}{(Shallow, Moderate, Steep);}
\item{Snow_Zone}{(Shallow, Moderate, Deep, Very Deep);}
\item{Solar_Insolation}{(Very Low, Low, Moderate, High, Very High));}
}
}
\value{
An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
}
\description{
Using Bayesian networks to map winter habitat for mountain goats in coastal British Columbia, Canada.
}
\references{
Wilson, S. F., Nietvelt, C., Taylor, S., & Guertin, D. A. (2022). Using Bayesian networks to map winter habitat for mountain goats in coastal British Columbia, Canada. Frontiers in Environmental Science, 10, 958596.
}
\keyword{KDep}
