% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series_table.R
\name{get_series_tables}
\alias{get_series_tables}
\title{Retrieve multiple time series in one API request and return a list of tibbles}
\usage{
get_series_tables(
  series_ids,
  api_key,
  start_year = NA,
  end_year = NA,
  year_limit = 20,
  parse_values = TRUE,
  ...
)
}
\arguments{
\item{series_ids}{a list or character vector of BLS time-series IDs. If the
list items are named then the names will be used in the returned list}

\item{api_key}{a mandatory API key, available from
\url{https://data.bls.gov/registrationEngine/}}

\item{start_year}{optional numeric 4-digit year}

\item{end_year}{optional numeric 4-digit year}

\item{year_limit}{optional number of years to paginate request by. Defaults
to 20, the API request cap when using API key. Requests made without an API
key are capped to 10 years.}

\item{parse_values}{optional boolean. If set to \code{true} (default) it will
attempt to parse the contents of \code{value} and cast numeric strings as numeric
values. If set to \code{false} it will keep return a \code{value} column of strings.}

\item{...}{additional parameters to pass to \code{\link{query_n_series}}}
}
\value{
a list of tables
}
\description{
Retrieve multiple time series in one API request and return a list of tibbles
}
\examples{
\dontrun{
get_series_tables(
  list(uer.men ='LNS14000001', uer.women = 'LNS14000002')),
  'your-api-key-here'
)
get_series_tables(
  list(uer.men ='LNS14000001', uer.women = 'LNS14000002'),
  'your-api-key-here',
  2005,2006
)
}

}
\seealso{
Other blsR-requests: 
\code{\link{bls_request}()},
\code{\link{get_all_surveys}()},
\code{\link{get_latest_observation}()},
\code{\link{get_n_series_table}()},
\code{\link{get_n_series}()},
\code{\link{get_popular_series}()},
\code{\link{get_series_table}()},
\code{\link{get_series}()},
\code{\link{get_survey_info}()}
}
\concept{blsR-requests}
