% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-gains-table.R
\name{blr_gains_table}
\alias{blr_gains_table}
\alias{plot.blr_gains_table}
\title{Gains table & lift chart}
\usage{
blr_gains_table(model, data = NULL)

\method{plot}{blr_gains_table}(
  x,
  title = "Lift Chart",
  xaxis_title = "\% Population",
  yaxis_title = "\% Cumulative 1s",
  diag_line_col = "red",
  lift_curve_col = "blue",
  plot_title_justify = 0.5,
  print_plot = TRUE,
  ...
)
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{data}{A \code{tibble} or a \code{data.frame}.}

\item{x}{An object of class \code{blr_gains_table}.}

\item{title}{Plot title.}

\item{xaxis_title}{X axis title.}

\item{yaxis_title}{Y axis title.}

\item{diag_line_col}{Diagonal line color.}

\item{lift_curve_col}{Color of the lift curve.}

\item{plot_title_justify}{Horizontal justification on the plot title.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}

\item{...}{Other inputs.}
}
\value{
A tibble.
}
\description{
Compute sensitivity, specificity, accuracy and KS statistics to
  generate the lift chart and the KS chart.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
             family = binomial(link = 'logit'))
# gains table
blr_gains_table(model)

# lift chart
k <- blr_gains_table(model)
plot(k)

}
\references{
Agresti, A. (2007), An Introduction to Categorical Data Analysis, Second Edition, New York: John Wiley & Sons.

Agresti, A. (2013), Categorical Data Analysis, Third Edition, New York: John Wiley & Sons.

Thomas LC (2009): Consumer  Credit  Models:  Pricing,  Profit,  and  Portfolio.
Oxford,  Oxford  Uni-versity Press.

Sobehart  J,  Keenan  S,  Stein  R  (2000):  Benchmarking  Quantitative  Default  Risk  Models:
A  Validation Methodology, Moody’s Investors Service.
}
\seealso{
Other model validation techniques: 
\code{\link{blr_confusion_matrix}()},
\code{\link{blr_decile_capture_rate}()},
\code{\link{blr_decile_lift_chart}()},
\code{\link{blr_gini_index}()},
\code{\link{blr_ks_chart}()},
\code{\link{blr_lorenz_curve}()},
\code{\link{blr_roc_curve}()},
\code{\link{blr_test_hosmer_lemeshow}()}
}
\concept{model validation techniques}
