% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-plots.R
\name{blr_plot_difdev_leverage}
\alias{blr_plot_difdev_leverage}
\title{Delta deviance vs leverage plot}
\usage{
blr_plot_difdev_leverage(
  model,
  point_color = "blue",
  title = "Delta Deviance vs Leverage Plot",
  xaxis_title = "Leverage",
  yaxis_title = "Delta Deviance"
)
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{point_color}{Color of the points.}

\item{title}{Title of the plot.}

\item{xaxis_title}{X axis label.}

\item{yaxis_title}{Y axis label.}
}
\description{
Delta deviance vs leverage plot.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

blr_plot_difdev_leverage(model)

}
