% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_functions.R
\name{toy_regularization}
\alias{toy_regularization}
\title{Implements the regularization functions used in the estimation}
\usage{
toy_regularization(left_index, right_index, nrow, ncol)
}
\arguments{
\item{left_index}{First index of the interval}

\item{right_index}{Last index of the interval}

\item{nrow}{Number of rows/signals/series}

\item{ncol}{Number of columns/variables}
}
\description{
The estimator in this package computes the optimum of
\eqn{-l(C, p) + \lambda*R(leftIndex, rightIndex, nrow, ncol)}, where l is the
log likelihood of the family, lambda is the penalization constant and R
is the regularization function. The user can create his own regularization
function and pass as an argument to \link[=fit_blockcpd]{fit_blockcpd}. It
should have four arguments, in the following order: left_index, right_index,
nrow and ncol. Each argument is explained in the parameter section.
If the function depends on leftIndex and rightIndex, it will be
non-homogeneous, which might be interesting in some applications.
The package implements some functions as an example, but uses only
bic_loss as the default. The algorithm is consistent as long as the
the regularization is bounded by a constant.
}
\examples{
my_reg <- function(leftIndex, rightIndex, nrow, ncol){
    block_size = (rightIndex - leftIndex + 1)
    return(log(nrow*ncol)*(1/block_size))
}
}
