% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomqu.r
\name{geomqu}
\alias{geomqu}
\title{On Affine Equivariant Multivariate Quantiles}
\usage{
geomqu(data, u, p, alpha, keep_optim = FALSE, keep_data = TRUE)
}
\arguments{
\item{data}{must be a (n,d) matrix of observations.}

\item{u}{a (m,d) matrix with m directions.}

\item{p}{defines the p-norm, must be in \eqn{[1,\infty)}.}

\item{alpha}{must be missing or a vector of length d+1 with distict values from 1 to n.}

\item{keep_optim}{boolean keep results from optimization in result object, default is FALSE.}

\item{keep_data}{boolean keep data parameter in result object, default is TRUE.}
}
\value{
an object of class \code{geomqu} with methods \code{\link{plot.geomqu}} and \code{\link{plot.geomqu}}.
}
\description{
This function fits empirical bivariate quantiles as proposed by  Chakraborty, B. (2001) <https://doi.org/10.1023/A:1012478908041>.
}
\references{
Chakraborty, B. (2001). On affine equivariant multivariate quantiles. 
\emph{Annals of the Institute of Statistical Mathematics}, \bold{53}, 380--. <https://doi.org/10.1023/A:1012478908041>.
}
\author{
Nadja Klein.
}
