% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extract.bm_bitmap.R
\name{[.bm_bitmap}
\alias{[.bm_bitmap}
\alias{[<-.bm_bitmap}
\title{Extract or replace parts of a bitmap}
\usage{
\method{[}{bm_bitmap}(x, i, j, ..., drop = TRUE)

\method{[}{bm_bitmap}(x, i, j, ...) <- value
}
\arguments{
\item{x}{\code{\link[=bm_bitmap]{bm_bitmap()}} object}

\item{i, j}{indices specifying elements to extract or replace.
See [base::\verb{[()}] for more information.}

\item{...}{Passed to [base::\verb{[()}].}

\item{drop}{If \code{TRUE} the result is coerced to a integer vector.}

\item{value}{Replacement value}
}
\value{
\verb{[.bm_bitmap()} returns a \code{bm_bitmap()} object if the value is a matrix  and/or \code{drop} is \code{FALSE}
otherwise it returns an integer matrix.
}
\description{
\verb{[.bm_bitmap()} is defined so that it returns a \code{bm_bitmap()} object
(if the value is a matrix) and \verb{[<-.bm_bitmap()} casts
any replacement values as integers.
}
\examples{
 font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
 font <- read_hex(font_file)
 capital_r <- font[[str2ucp("R")]]
 print(capital_r[4:14,2:8], px = px_ascii)
 capital_r[11:13,3:5] <- 2L
 print(capital_r, px = px_ascii)
}
