% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_distort.R
\name{bm_distort}
\alias{bm_distort}
\title{Resize images via distortion.}
\usage{
bm_distort(
  bm_object,
  width = NULL,
  height = NULL,
  interpolate = FALSE,
  vp = NULL,
  png_device = NULL,
  threshold = 0.25
)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{width}{Desired width of bitmap}

\item{height}{Desired height of bitmap}

\item{interpolate}{Passed to \code{\link[grid:grid.raster]{grid::grid.raster()}}.}

\item{vp}{A \code{\link[grid:viewport]{grid::viewport()}} object that could be used to further manipulate the image.}

\item{png_device}{A function taking arguments \code{filename}, \code{width}, and \code{height}
that starts a graphics device that saves a png image
with a transparent background.  By default will use \code{\link[ragg:agg_png]{ragg::agg_png()}}
if available else the \dQuote{cairo} version of \code{\link[grDevices:png]{grDevices::png()}}
if available else just \code{\link[grDevices:png]{grDevices::png()}}.}

\item{threshold}{If any png channel weakly exceeds this threshold
(on an interval from zero to one)
then the pixel is determined to be \dQuote{black}.}
}
\value{
Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, or \code{\link[=bm_font]{bm_font()}} object.
}
\description{
\code{bm_distort()} resize images to arbitrary width and height value via distortion.
}
\details{
\code{bm_distort()} generates a distorted \code{\link[grid:grid.raster]{grid::rasterGrob()}} with the help of
\code{\link[=as.raster.bm_bitmap]{as.raster.bm_bitmap()}} which is then converted back to a
\code{\link[=bm_bitmap]{bm_bitmap()}} via \code{\link[=as_bm_bitmap.grob]{as_bm_bitmap.grob()}}.
}
\examples{
 font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
 font <- read_hex(font_file)
 capital_r <- font[[str2ucp("R")]]
 dim(capital_r) # 8 x 16
 if (require("grid") && capabilities("png")) {
   print(bm_distort(capital_r, width = 9L, height = 21L), px = px_ascii)
 }
}
\seealso{
\code{\link[=bm_expand]{bm_expand()}} for expanding width/height by integer multiples.
\code{\link[=bm_resize]{bm_resize()}} for resizing an image via trimming/extending an image.
}
