% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trades.R
\name{trades}
\alias{trades}
\title{Individual trade data}
\usage{
trades(
  symbol = "XBTUSD",
  count = 1000,
  reverse = "true",
  filter = NULL,
  columns = NULL,
  start = NULL,
  startTime = NULL,
  endTime = NULL
)
}
\arguments{
\item{symbol}{a character string for the instrument symbol.
Use \code{\link[=available_symbols]{available_symbols()}} to see available symbols.}

\item{count}{an optional integer to specify the number of rows to return.
Maximum of 1000 (the default) per request.}

\item{reverse}{an optional character string. Either \code{"true"} of \code{"false"}.
If \code{"true"}, result will be ordered with starting with the newest (defaults to \code{"true"}).}

\item{filter}{an optional character string for table filtering.
Send JSON key/value pairs, such as \code{"{'key':'value'}"}. See examples.}

\item{columns}{an optional character vector of column names to return.
If \code{NULL}, all columns will be returned.}

\item{start}{an optional integer. Can be used to specify the starting point for results.}

\item{startTime}{an optional character string.
Starting date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{endTime}{an optional character string.
Ending date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}
}
\value{
\code{trades()} returns a \code{data.frame} containing:
\itemize{
\item{timestamp: }{POSIXct. Date and time of trade.}
\item{symbol: }{character. The instrument ticker.}
\item{side: }{character. Whether the trade was buy or sell.}
\item{size: }{numeric. Size of the trade.}
\item{price: }{numeric. Price the trade was executed at}
\item{tickDirection: }{character. Indicates if the trade price was higher, lower or the same as the previous trade price.}
\item{trdMatchID: }{character. Unique trade ID.}
\item{grossValue: }{numeric. How many satoshi were exchanged. 1 satoshi = 0.00000001 BTC.}
\item{homeNotional: }{numeric. BTC value of the trade.}
\item{foreignNotional: }{numeric. USD value of the trade.}
}
}
\description{
\code{trades()} retrieves data regarding individual trades that have been executed on the
exchange.
}
\examples{
\donttest{
# Return 1000 most recent trades for symbol "XBTUSD".
trades(symbol = "XBTUSD")

# Use filter for very specific values: Return trade data executed at 12:15.
trades(
  symbol = "XBTUSD",
  filter = "{'timestamp.minute':'12:15'}"
)

# Also possible to combine more than one filter.
trades(
  symbol = "XBTUSD",
  filter = "{'timestamp.minute':'12:15', 'size':10000}"
)
}

}
\references{
\url{https://www.bitmex.com/api/explorer/#!/Trade/Trade_get}
}
\concept{map_trades}
