% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bistablehistory-package.R
\docType{package}
\name{bistablehistory-package}
\alias{bistablehistory-package}
\alias{bistablehistory}
\title{Cumulative History Analysis for Bistable Perception Time Series}
\description{
Estimates cumulative history for time-series for continuously
viewed bistable perceptual rivalry displays. Computes cumulative history
via a homogeneous first order differential process. I.e., it assumes
exponential growth/decay of the history as a function time and perceptually
dominant state, Pastukhov & Braun (2011) \doi{10.1167/11.10.12}.
Supports Gamma, log normal, and normal distribution families.
Provides a method to compute history directly and example of using the
computation on a custom Stan code.
}
\references{
Stan Development Team (2020). RStan: the R interface to Stan. R package version 2.21.2. https://mc-stan.org
}
\seealso{
\code{vignette("cumulative-history", package = "bistablehistory")}
\code{vignette("usage-examples", package = "bistablehistory")}
\code{vignette("writing-stan-code", package = "bistablehistory")}
}
