% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_pos}
\alias{birdnik_get}
\alias{get_pos}
\alias{get_score}
\alias{get_text}
\title{Extract components from word metadata}
\usage{
get_pos(results)

get_text(results)

get_score(results)
}
\arguments{
\item{results}{the results of a call to \code{\link{word_definitions}}.}
}
\value{
a data.frame of two columns - \code{word} (containing the word)
and a second column of \code{score}, \code{text} or \code{part_of_speech}
depending on the function you called.
}
\description{
these functions allow you to extract particular components
from wordnik definitions; \code{get_pos} the unique parts-of-speech,
\code{get_text} the unique definitions for each word, and \code{get_score}
the unique word scores.
}
\examples{
\dontrun{
# Retrieve the unique parts-of-speech for 'no' and 'kings'
no_kings <- word_definitions(key = "madeupkey", words = c("no", "kings"))
get_pos(no_kings)
}

}

