% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVA.R
\name{CVA.biplot}
\alias{CVA.biplot}
\title{CVA biplot}
\usage{
\method{CVA}{biplot}(
  bp,
  dim.biplot = c(2, 1, 3),
  e.vects = 1:ncol(bp$X),
  classes = bp$classes,
  weightedCVA = "weighted",
  show.class.means = TRUE
)
}
\arguments{
\item{bp}{object of class \code{biplot} obtained from preceding function \code{biplot()}.}

\item{dim.biplot}{dimension of the biplot. Only values 1, 2 and 3 are accepted, with default \code{2}.}

\item{e.vects}{which eigenvectors (canonical variates) to extract, with default \code{1:dim.biplot}.}

\item{classes}{vector of the same length as the number of rows in the data matrix
with the class indicator for the samples.}

\item{weightedCVA}{the default is "weighted", specifying a weighted CVA to be performed. Other possible values are "unweightedI" and "unweightedCent".}

\item{show.class.means}{logical, indicating whether to plot the class means on the biplot.}
}
\value{
an object of class CVA, inherits from class biplot.
}
\description{
Performs calculations for a CVA biplot.
}
\examples{
biplot(iris[,1:4]) |> CVA(classes=iris[,5])

}
