% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DI_plot_helpers.R
\name{DI_dendrogram}
\alias{DI_dendrogram}
\title{Plot dissimilarities withing and among sets of selected sites as a dendrogram}
\usage{
DI_dendrogram(DI_selected_sites, selection_type = "selections",
              selection_number = 1, labels = NULL, xlab = "",
              ylab = "Distance", main = "Cluster dendrogram",
              sub = "", ...)
}
\arguments{
\item{DI_selected_sites}{list of results obtained with function
\code{\link{selected_sites_DI}}.}

\item{selection_type}{type of selection to be considered when creating DI
matrix plot. Options are: "selections", "random", "E", "G", and "EG".
The default, "selections", plots a comparison among all selection types.}

\item{selection_number}{(numeric) number of selection to be plotted.
Default = 1. Ignored if \code{selection_type} = "selections".}

\item{labels}{(character) vector of labels for the tips of the tree.
The default, NULL, uses names of sets of selected sites. If labels = FALSE
no tip labels are plotted.}

\item{xlab}{(character) label for x-axis of plot. Default = "".}

\item{ylab}{(character) label for y-axis of plot. Default = "Distance".}

\item{main}{(character) title for the plot. Default = "Cluster dendrogram".}

\item{sub}{(character) subtitle for the plot. Plotted below the label of
the x-axis.}

\item{...}{other arguments to be passed to plot method for objects of class
"\code{hclust}". See more details in \code{\link[stats]{hclust}}.}
}
\value{
A dendrogram plot of a "\code{hclust}" object.
}
\description{
Plot dissimilarities withing and among sets of selected sites as a dendrogram
}
\examples{
# Data
data("b_pam", package = "biosurvey")
data("m_selection", package = "biosurvey")

# Subsetting base PAM according to selections
sub_pam_all <- subset_PAM(b_pam, m_selection, selection_type = "all")

# Calculating dissimilarities
DI_sel <- selected_sites_DI(sub_pam_all)

# Plot
DI_dendrogram(DI_sel)
}
