% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_to_mat.R
\name{net_to_mat}
\alias{net_to_mat}
\title{Create a contingency table from a data.frame}
\usage{
net_to_mat(
  net,
  weight = FALSE,
  squared = FALSE,
  symmetrical = FALSE,
  missing_value = 0
)
}
\arguments{
\item{net}{a two- or three-columns \code{data.frame} where each row
represents the interaction between two nodes (site and species for example)
and an optional third column indicating the weight of the interaction.}

\item{weight}{a \code{boolean} indicating if the weight should be considered}

\item{squared}{a \code{boolean} indicating if the output matrix should but
squared (same nodes in rows and columns).}

\item{symmetrical}{a \code{boolean} indicating if the resulting matrix
should be symmetrical (only if \code{squared = TRUE}).
Note that different weights associated with two opposite pairs already
present in net will be preserved.}

\item{missing_value}{the value to assign to the pairs of nodes not present
in net (0 by default).}
}
\value{
A \code{matrix} with the first nodes (first column of \code{net}) as
rows and the second nodes (second column of \code{net}) as columns. Note
that if \code{squared = TRUE} the rows and columns have the same number of
elements corresponding to the concatenation of unique objects in
\code{net}'s first and second columns. If \code{squared = TRUE} the matrix
can be forced to be symmetrical based on the upper triangular part of the
matrix.
}
\description{
This function creates a contingency table from a two- or three-columns
\code{data.frame} where each row represents the interaction between two
nodes (site and species for example) and an optional third column indicating
the weight of the interaction (if \code{weight = TRUE}).
}
\examples{
net <- data.frame(
  Site = c(rep("A", 2), rep("B", 3), rep("C", 2)),
  Species = c("a", "b", "a", "c", "d", "b", "d"),
  Weight = c(10, 100, 1, 20, 50, 10, 20)
)

mat <- net_to_mat(net, weight = TRUE)

}
\seealso{
\link{mat_to_net}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}),
Pierre Denelle (\email{pierre.denelle@gmail.com}) and
Boris Leroy (\email{leroy.boris@gmail.com})
}
