% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity_dissimilarity_conversion.R
\name{similarity_to_dissimilarity}
\alias{similarity_to_dissimilarity}
\title{Convert similarity indices to dissimilarity metrics}
\usage{
similarity_to_dissimilarity(similarity)
}
\arguments{
\item{similarity}{the output object from \code{\link[=similarity]{similarity()}} or a
\code{data.frame} with the first columns called "Site1" and "Site2", and the
other columns being the similarity metrics.}
}
\value{
A \code{data.frame} with additional class
\code{bioregion.pairwise.metric}, providing one or several similarity
metric(s) between each pair of sites. The two first columns represent each
pair of sites, and the other column represent similarity metrics. Columns
with names "a", "b", "c", "A", "B" and "C"  are not altered.
}
\description{
This function converts a data.frame of similarity metrics between sites to
dissimilarity metrics (= beta diversity).
}
\note{
\loadmathjax
The behavior of this function changes depending on column names. Columns
"Site1" and "Site2" are copied identically. If there are columns called
"a", "b", "c", "A", "B", "C", they will also be copied identically.

If a column is called "Euclidean", its distance will be calculated based
on the following formula:

\mjeqn{Euclidean distance = (1 - Euclidean similarity) / Euclidean similarity}{Euclidean distance = (1 - Euclidean similarity) / Euclidean similarity}

Otherwise, all other columns will be transformed into dissimilarity with the
following formula:

\mjeqn{dissimilarity = 1 - similarity}{dissimilarity = 1 - similarity}
}
\examples{
comat <- matrix(sample(0:1000, size = 50, replace = TRUE,
prob = 1 / 1:1001), 5, 10)
rownames(comat) <- paste0("Site", 1:5)
colnames(comat) <- paste0("Species", 1:10)

simil <- similarity(comat, metric = "all")
simil

dissimilarity <- similarity_to_dissimilarity(simil)
dissimilarity

}
\seealso{
\code{\link[=dissimilarity_to_similarity]{dissimilarity_to_similarity()}}
}
\author{
Boris Leroy (\email{leroy.boris@gmail.com}),
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}) and
Pierre Denelle (\email{pierre.denelle@gmail.com})
}
