% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_Tuning.R
\name{bm_Tuning}
\alias{bm_Tuning}
\title{Tune models parameters}
\usage{
bm_Tuning(
  model,
  tuning.fun,
  do.formula = FALSE,
  do.stepAIC = FALSE,
  bm.options,
  bm.format,
  calib.lines = NULL,
  metric.eval = "TSS",
  metric.AIC = "AIC",
  weights = NULL,
  ctrl.train = NULL,
  params.train = list(ANN.size = c(2, 4, 6, 8), ANN.decay = c(0.01, 0.05, 0.1), ANN.bag =
    FALSE, DNN.hidden = list(depth = 3, width = 100), DNN.bias = TRUE, DNN.lambda =
    0.001, DNN.alpha = 1, DNN.lr = c(1e-04, 0.1), DNN.batchsize = 100, DNN.epochs = 150,
    FDA.degree = 1:2, FDA.nprune = 2:25, GAM.select = c(TRUE, FALSE), GAM.method =
    c("GCV.Cp", "GACV.Cp", "REML", "P-REML", "ML", "P-ML"), GAM.span = c(0.3, 0.5, 0.7),
    GAM.degree = 1, GBM.n.trees = c(500, 1000, 2500), GBM.interaction.depth = seq(2, 8,
    by = 3), GBM.shrinkage = c(0.001, 
     0.01, 0.1), GBM.n.minobsinnode = 10,
    MARS.degree = 1:2, MARS.nprune = 2:max(21, 2 * ncol(bm.format@data.env.var) + 1),
    MAXENT.algorithm = "maxnet", MAXENT.parallel = TRUE, MAXENT.tune.args = list(rm =
    seq(0.5, 1, 0.5), fc = c("L")), MAXENT.partitions = "randomkfold", MAXENT.kfolds =
    10, MAXENT.user.grp = NULL, RF.mtry = 1:min(10, ncol(bm.format@data.env.var)),
    RFd.mtry = 1:min(10, ncol(bm.format@data.env.var)), SRE.quant = c(0, 0.0125, 0.025,
    0.05, 0.1), XGBOOST.nrounds = 50, XGBOOST.max_depth = 1, 
     XGBOOST.eta = c(0.3,
    0.4), XGBOOST.gamma = 0, XGBOOST.colsample_bytree = c(0.6, 0.8),
    XGBOOST.min_child_weight = 1, XGBOOST.subsample = 0.5)
)
}
\arguments{
\item{model}{a \code{character} corresponding to the  algorithm to be tuned, must be either 
\code{ANN}, \code{CTA}, \code{DNN}, \code{FDA}, \code{GAM}, \code{GBM}, \code{GLM}, \code{MARS}, 
\code{MAXENT}, \code{MAXNET}, \code{RF}, \code{RFd}, \code{SRE}, \code{XGBOOST}}

\item{tuning.fun}{a \code{character} corresponding to the model function name to be called 
through \code{\link[caret]{train}} function for tuning parameters (see \code{\link{ModelsTable}} 
dataset)}

\item{do.formula}{(\emph{optional, default} \code{FALSE}) \cr
A \code{logical} value defining whether formula is to be optimized or not}

\item{do.stepAIC}{(\emph{optional, default} \code{FALSE}) \cr
A \code{logical} value defining whether variables selection is to be performed for 
\code{GLM} and \code{GAM} models or not}

\item{bm.options}{a \code{\link{BIOMOD.options.default}} or \code{\link{BIOMOD.options.dataset}} 
object returned by the \code{\link{bm_ModelingOptions}} function}

\item{bm.format}{a \code{\link{BIOMOD.formated.data}} or \code{\link{BIOMOD.formated.data.PA}} 
object returned by the \code{\link{BIOMOD_FormatingData}} function}

\item{calib.lines}{(\emph{optional, default} \code{NULL}) \cr
A \code{data.frame} object returned by \code{\link{get_calib_lines}} or 
\code{\link{bm_CrossValidation}} functions}

\item{metric.eval}{a \code{character} corresponding to the evaluation metric to be used, must 
be either \code{AUC}, \code{Kappa} or \code{TSS} for \code{SRE} only ; \code{auc.val.avg}, 
\code{auc.diff.avg}, \code{or.mtp.avg}, \code{or.10p.avg}, \code{AICc} for \code{MAXENT} only ; 
\code{ROC} or \code{TSS} for all other models}

\item{metric.AIC}{a \code{character} corresponding to the AIC metric to be used, must 
be either \code{AIC} or \code{BIC}}

\item{weights}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} of \code{numeric} values corresponding to observation weights (one per 
observation, see Details)}

\item{ctrl.train}{(\emph{optional, default} \code{NULL}) \cr 
A \code{\link[caret]{trainControl}} object}

\item{params.train}{a \code{list} containing values of model parameters to be tested 
(see Details)}
}
\value{
A \code{\link{BIOMOD.models.options}} object (see \code{\link{bm_ModelingOptions}}) with 
optimized parameters
}
\description{
This internal \pkg{biomod2} function allows to tune single model parameters and 
select more efficient ones based on an evaluation metric.
}
\details{
\bold{Concerning \code{ctrl.train} parameter :}

Set by default to : \cr

\code{ctrl.train <- caret::trainControl(method = "repeatedcv", repeats = 3, number = 10,} \cr
\code{summaryFunction = caret::twoClassSummary,} \cr
\code{classProbs = TRUE, returnData = FALSE)} \cr \cr


\bold{Concerning \code{params.train} parameter :}

All elements of the \code{list} must have names matching \code{model.parameter_name} format, 
\code{parameter_name} being one of the parameter of the \code{tuning.fun} function called by 
\code{caret} package and that can be found through the \code{\link[caret]{getModelInfo}} 
function.

Currently, the available parameters to be tuned are the following :
\describe{
  \item{ANN}{\code{size}, \code{decay}, \code{bag}}
  \item{CTA}{\code{maxdepth}}
  \item{DNN}{\code{hidden} , \code{bias}, \code{lambda}, \code{alpha}, \code{lr}, \code{batchsize}, \code{150}}
  \item{FDA}{\code{degree}, \code{nprune}}
  \item{GAM.gam}{\code{span}, \code{degree}}
  \item{GAM.mgcv}{\code{select}, \code{method}}
  \item{GBM}{\code{n.trees}, \code{interaction.depth}, \code{shrinkage}, \code{n.minobsinnode}}
  \item{MARS}{\code{degree}, \code{nprune}}
  \item{MAXENT}{\code{algorithm},\code{tune.args}, \code{parallel}, \code{partitions}, \code{kfolds}, 
  \code{user.grp}}
  \item{RF}{\code{mtry}}
  \item{RFd}{\code{mtry}}
  \item{SRE}{\code{quant}}
  \item{XGBOOST}{\code{nrounds}, \code{max_depth}, \code{eta}, \code{gamma}, 
  \code{colsampl_bytree}, \code{min_child_weight}, \code{subsample}}
}


The \code{\link{expand.grid}} function is used to build a \code{matrix} containing all 
combinations of parameters to be tested.
}
\note{
\itemize{
  \item No tuning for \code{GLM} and \code{MAXNET}
  \item \code{MAXENT} is tuned through \code{\link[ENMeval]{ENMevaluate}} function which is
  calling either :
  \itemize{
    \item maxnet (by defining \code{MAXENT.algorithm = 'maxnet'}) (\emph{default})
    \item Java version of Maxent defined in \pkg{dismo} package (by defining 
    \code{MAXENT.algorithm = 'maxent.jar'})
  }
  \item \code{DNN} is tuned through \code{\link[cito]{tune}} function. 
  The values include in \code{params.train} are the lower or upper range which hyperparameters are sampled.
  If there is only one value, the hyperparameter is fixed by biomod2 (inclunding the width and depth of \code{hidden} parameters.) 
  \item \code{SRE} is tuned through \code{\link{bm_SRE}} function
  \item All other models are tuned through \code{\link[caret]{train}} function
  \item No optimization of formula for \code{DNN}, \code{MAXENT}, \code{MAXNET}, \code{SRE} and 
  \code{XGBOOST}
  \item No interaction included in formula for \code{CTA}
  \item Variables selection only for \code{GAM.gam} and \code{GLM}
}
}
\examples{
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

# --------------------------------------------------------------- #
# Format Data with true absences
myBiomodData <- BIOMOD_FormatingData(resp.name = myRespName,
                                     resp.var = myResp,
                                     resp.xy = myRespXY,
                                     expl.var = myExpl)


# --------------------------------------------------------------- #
# List of all models currently available in `biomod2` (and their related package and function)
# Some of them can be tuned through the `train` function of the `caret` package 
# (and corresponding training function to be used is indicated)
data(ModelsTable)
ModelsTable

allModels <- c('ANN', 'CTA', 'FDA', 'GAM', 'GBM', 'GLM'
               , 'MARS', 'MAXENT', 'MAXNET', 'RF', 'SRE', 'XGBOOST')

# default parameters
opt.d <- bm_ModelingOptions(data.type = 'binary',
                            models = allModels,
                            strategy = 'default')
                            
# tune parameters for Random Forest model
tuned.rf <- bm_Tuning(model = 'RF',
                      tuning.fun = 'rf', ## see in ModelsTable
                      do.formula = FALSE,
                      bm.options = opt.d@options$RF.binary.randomForest.randomForest,
                      bm.format = myBiomodData)
tuned.rf

\dontrun{
# tune parameters for GAM (from mgcv package) model
tuned.gam <- bm_Tuning(model = 'GAM',
                       tuning.fun = 'gam', ## see in ModelsTable
                       do.formula = TRUE,
                       do.stepAIC = TRUE,
                       bm.options = opt.d@options$GAM.binary.mgcv.gam,
                       bm.format = myBiomodData)
tuned.gam
}                  



}
\seealso{
\code{\link[caret]{trainControl}}, \code{\link[caret]{train}}, 
\code{\link[ENMeval]{ENMevaluate}}, 
\code{\link{ModelsTable}}, \code{\link{BIOMOD.models.options}}, 
\code{\link{bm_ModelingOptions}}, \code{\link{BIOMOD_Modeling}}

Other Secondary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_ModelAnalysis}()},
\code{\link{bm_ModelingOptions}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RangeSize}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Frank Breiner, Maya Guéguen, Hélène Blancheteau
}
\concept{Secondary functions}
