% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_0.R
\docType{class}
\name{BIOMOD.options.default}
\alias{BIOMOD.options.default}
\alias{BIOMOD.options.default-class}
\alias{BIOMOD.options.default,character,character-method}
\title{\code{\link{bm_ModelingOptions}} output object class}
\usage{
\S4method{BIOMOD.options.default}{character,character}(mod, typ, pkg, fun)
}
\arguments{
\item{mod}{a \code{character} corresponding to the model name to be computed, must be either 
\code{ANN}, \code{CTA}, \code{DNN}, \code{FDA}, \code{GAM}, \code{GBM}, \code{GLM}, \code{MARS}, 
\code{MAXENT}, \code{MAXNET}, \code{RF}, \code{SRE}, \code{XGBOOST}}

\item{typ}{a \code{character} corresponding to the data type to be used, must be either 
\code{binary}, \code{binary.PA}, \code{abundance}, \code{compositional}}

\item{pkg}{a \code{character} corresponding to the package containing 
the model function to be called}

\item{fun}{a \code{character} corresponding to the model function name 
to be called}
}
\description{
Class returned by \code{\link{bm_ModelingOptions}} (a 
\code{list} of \code{BIOMOD.options.dataset} more exactly), and used by 
\code{\link{BIOMOD_Modeling}}
}
\section{Slots}{

\describe{
\item{\code{model}}{a \code{character} corresponding to the model}

\item{\code{type}}{a \code{character} corresponding to the data type 
(\code{binary}, \code{binary.PA}, \code{abundance}, \code{compositional})}

\item{\code{package}}{a \code{character} corresponding to the package containing 
the model function to be called}

\item{\code{func}}{a \code{character} corresponding to the model function name 
to be called}

\item{\code{args.names}}{a \code{vector} containing \code{character} corresponding 
to the model function arguments}

\item{\code{args.default}}{a \code{list} containing for each dataset the default 
values for all arguments listed in \code{args.names}}
}}

\examples{

showClass("BIOMOD.options.default")


}
\seealso{
\code{\link{BIOMOD.options.dataset}}, \code{\link{bm_ModelingOptions}}, 
\code{\link{bm_Tuning}}, \code{\link{BIOMOD_Modeling}}, \code{\link{bm_RunModelsLoop}}

Other Toolbox objects: 
\code{\link{BIOMOD.ensemble.models.out}},
\code{\link{BIOMOD.formated.data}},
\code{\link{BIOMOD.formated.data.PA}},
\code{\link{BIOMOD.models.options}},
\code{\link{BIOMOD.models.out}},
\code{\link{BIOMOD.options.dataset}},
\code{\link{BIOMOD.projection.out}},
\code{\link{BIOMOD.rangesize.out}},
\code{\link{BIOMOD.stored.data}},
\code{\link{biomod2_ensemble_model}},
\code{\link{biomod2_model}}
}
\author{
Maya Guéguen
}
\concept{Toolbox objects}
