% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_PlotEvalMean.R
\name{bm_PlotEvalMean}
\alias{bm_PlotEvalMean}
\title{Plot mean evaluation scores}
\usage{
bm_PlotEvalMean(
  bm.out,
  metric.eval = NULL,
  group.by = "algo",
  do.plot = TRUE,
  ...
)
}
\arguments{
\item{bm.out}{a \code{\link{BIOMOD.models.out}} or \code{\link{BIOMOD.ensemble.models.out}} 
object that can be obtained with the \code{\link{BIOMOD_Modeling}} or 
\code{\link{BIOMOD_EnsembleModeling}} functions}

\item{metric.eval}{a \code{vector} containing evaluation metric names to be used, must 
be among \code{ROC}, \code{TSS}, \code{KAPPA}, \code{ACCURACY}, \code{BIAS}, \code{POD}, 
\code{FAR}, \code{POFD}, \code{SR}, \code{CSI}, \code{ETS}, \code{HK}, \code{HSS}, \code{OR}, 
\code{ORSS}}

\item{group.by}{a \code{character} corresponding to the way kept models will be combined to 
compute mean and sd evaluation scores, must be among \code{model}, \code{algo}, \code{run}, 
\code{dataset}}

\item{do.plot}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the plot is to be rendered or not}

\item{\ldots}{some additional arguments (see Details)}
}
\value{
A \code{list} containing a \code{data.frame} with mean and standard deviation of evaluation 
scores and the corresponding \code{ggplot} object representing them according to 2 different 
evaluation methods.
}
\description{
This function represents mean evaluation scores (and their standard deviation) 
of species distribution models, from \code{\link{BIOMOD.models.out}} or 
\code{\link{BIOMOD.ensemble.models.out}} objects that can be obtained from 
\code{\link{BIOMOD_Modeling}} or \code{\link{BIOMOD_EnsembleModeling}} functions. Scores are 
represented according to 2 different evaluation methods, and models can be grouped 
(see Details).
}
\details{
\code{...} can take the following values :

\itemize{
  \item{\code{xlim}}{ : an \code{integer} corresponding to the x maximum limit to represent}
  \item{\code{ylim}}{ : an \code{integer} corresponding to the y maximum limit to represent}
  \item{\code{main}}{ : a \code{character} corresponding to the graphic title}
  \item{\code{col}}{ : a \code{vector} containing new color values}
}
}
\examples{

# Load species occurrences (6 species available)
myFile <- system.file('external/species/mammals_table.csv', package = 'biomod2')
DataSpecies <- read.csv(myFile, row.names = 1)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
myFiles <- paste0('external/bioclim/current/bio', c(3, 4, 7, 11, 12), '.grd')
myExpl <- raster::stack(system.file(myFiles, package = 'biomod2'))

\dontshow{
myExtent <- raster::extent(0,30,45,70)
myExpl <- raster::stack(raster::crop(myExpl, myExtent))
}

# ---------------------------------------------------------------
file.out <- paste0(myRespName, "/", myRespName, ".AllModels.models.out")
if (file.exists(file.out)) {
  myBiomodModelOut <- get(load(file.out))
} else {

  # Format Data with true absences
  myBiomodData <- BIOMOD_FormatingData(resp.var = myResp,
                                       expl.var = myExpl,
                                       resp.xy = myRespXY,
                                       resp.name = myRespName)

  # Create default modeling options
  myBiomodOptions <- BIOMOD_ModelingOptions()

  # Model single models
  myBiomodModelOut <- BIOMOD_Modeling(bm.format = myBiomodData,
                                      modeling.id = 'AllModels',
                                      models = c('RF', 'GLM'),
                                      bm.options = myBiomodOptions,
                                      nb.rep = 2,
                                      data.split.perc = 80,
                                      metric.eval = c('TSS','ROC'),
                                      var.import = 3,
                                      do.full.models = FALSE,
                                      seed.val = 42)
}


# ---------------------------------------------------------------
# Get evaluation scores
get_evaluations(myBiomodModelOut)

# Represent mean evaluation scores
bm_PlotEvalMean(bm.out = myBiomodModelOut)


}
\seealso{
\code{\link{BIOMOD.models.out}}, \code{\link{BIOMOD.ensemble.models.out}}, 
\code{\link{BIOMOD_Modeling}}, \code{\link{BIOMOD_EnsembleModeling}}, 
\code{\link{get_evaluations}}

Other Secundary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CVnnet}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_VariablesImportance}()}

Other Plot functions: 
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()}
}
\author{
Damien Georges, Maya Gueguen
}
\concept{Plot functions}
\concept{Secundary functions}
\keyword{evaluation}
\keyword{ggplot}
