% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbLocation-class.R
\docType{class}
\name{gbLocation-class}
\alias{gbLocation-class}
\title{Class \code{"gbLocation"}}
\description{
\dQuote{gbLocation} is an S4 class that provides a container for
GenBank feature location descriptors.
}
\details{
For more information see the 
\href{ftp://ftp.ncbi.nih.gov/genbank/gbrel.txt}{GenBank Release Note}
}
\section{Slots}{

\describe{
\item{\code{range}}{An integer matrix indicating the base numbers delimiting a
sequence span.}

\item{\code{fuzzy}}{A logical matrix indicating fuzzy start and/or end
(e.g. <1..200).}

\item{\code{strand}}{An integer vector containing -1, 1, or NA.}

\item{\code{compound}}{A character code specifying how multiple ranges
are joined. One of \sQuote{join}, \sQuote{order}, or \sQuote{bond}.}

\item{\code{accession}}{A character vector; the accession number of the sequence
of the feature this location lives on.}

\item{\code{remote}}{A logical vector}

\item{\code{type}}{A character vector describing the type of the position. Normally
an "R" for \sQuote{range} (e.g., \code{1..200} or point position \code{200}),
a "B" for \sQuote{between bases} (e.g., \code{36^37}), or a "G" for gaps
(e.g., \code{gap()}, \code{gap(30)}, or \code{gap(unk30)}).}
}}

\keyword{classes}
\keyword{internal}
