% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_into_vpts.R
\name{vplist_to_vpts}
\alias{vplist_to_vpts}
\title{Bind vertical profiles (\code{vp}) into time series (\code{vpts})}
\usage{
vplist_to_vpts(x, radar = NA)
}
\arguments{
\item{x}{A list of \code{vp} objects, usually a result of a call
to \link{read_vpfiles}.}

\item{radar}{optional string containing the radar identifier to generate
time series for.}
}
\value{
an object of class \link[=summary.vpts]{vpts} when \code{list}
contains profiles of a single radar. A list of objects of class
\link[=summary.vpts]{vpts} in case when \code{list} contains profiles of
multiple radars, containing \link[=summary.vpts]{vpts} objects for each radar.
}
\description{
Used as helper function for the method dispatched \code{bind_into_vpts} and
keeping backward compatibility with the \code{vpts} function.
}
\examples{
\dontrun{
vps <- read_vpfiles(c("my/path/profile1.h5", "my/path/profile2.h5", ...))
ts <- bind_into_vpts(vps)
}
}
\keyword{internal}
