% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cajun.R
\name{read_cajun}
\alias{read_cajun}
\title{Read a vertical profile (\code{vp}) from UMASS Cajun text file}
\usage{
read_cajun(file, rcs = 11, wavelength = "S")
}
\arguments{
\item{file}{A text file containing the standard output (stdout) generated
by UMASS Cajun pipeline}

\item{rcs}{numeric. Radar cross section per bird in cm^2.}

\item{wavelength}{Radar wavelength in cm, or one of 'C' or 'S' for C-band and S-band radar, respectively,
in which case C-band wavelength is assumed to be 5.3 cm and S-band wavelength 10.6 cm}
}
\value{
An object inheriting from class \code{vp}, see
\code{\link[=summary.vp]{vp}} for details.
}
\description{
Read a vertical profile (\code{vp}) from UMASS Cajun text file
}
