% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC.R
\name{AUC}
\alias{AUC}
\alias{AUC}
\alias{AUCBoot}
\title{AUC}
\usage{
AUC(pred, target, digits = NULL)

AUCBoot(pred, target, nboot = 10000, seed = NA, digits = NULL)
}
\arguments{
\item{pred}{Vector of predictions.}

\item{target}{Vector of true labels (must have exactly two levels,
no missing values).}

\item{digits}{See \link{round}. Default doesn't use rounding.}

\item{nboot}{Number of bootstrap samples to evaluate the 95\% CI.
Default is \code{1e3}.}

\item{seed}{See \link{set.seed}. Use it for reproducibility.
Default doesn't set any seed.}
}
\value{
The AUC, a probability, and possibly its 2.5\% and 97.5\% quantiles
(95\% CI).
}
\description{
Compute the Area Under the ROC Curve (AUC) of a predictor
and possibly its 95\% confidence interval.
}
\details{
Other packages provide ways to compute the AUC (see this
\href{http://stats.stackexchange.com/a/146174/135793}{answer}).
I chose to compute the AUC through its statistical definition as a
probability: \deqn{P(score(x_{case}) > score(x_{control})).}
Note that I consider equality between scores as a 50\%-probability of
one being greater than the other.
}
\examples{
set.seed(1)

AUC(c(0, 0), 0:1) # Equality of scores
AUC(c(0.2, 0.1, 1), c(-1, -1, 1)) # Perfect AUC
x <- rnorm(100)
z <- rnorm(length(x), x, abs(x))
y <- sign(z)
print(AUC(x, y))
print(AUCBoot(x, y))
}
\references{
Hanley, J. A., & McNeil, B. J. (1982).
The meaning and use of the area under a
receiver operating characteristic (ROC) curve.
Radiology, 143(1), 29-36.
\url{http://dx.doi.org/10.1148/radiology.143.1.7063747}.

Tom Fawcett. 2006. An introduction to ROC analysis.
Pattern Recogn. Lett. 27, 8 (June 2006), 861-874.
\url{http://dx.doi.org/10.1016/j.patrec.2005.10.010}.
}
\seealso{
\link{wilcox.test}
}
