% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job-query.R
\name{insert_query_job}
\alias{insert_query_job}
\title{Create a new query job.}
\usage{
insert_query_job(query, project, destination_table = NULL,
  default_dataset = NULL, create_disposition = "CREATE_IF_NEEDED",
  write_disposition = "WRITE_EMPTY", use_legacy_sql = TRUE, ...)
}
\arguments{
\item{query}{SQL query string}

\item{project}{The project name, a string}

\item{destination_table}{(optional) destination table for large queries,
either as a string in the format used by BigQuery, or as a list with
\code{project_id}, \code{dataset_id}, and \code{table_id} entries}

\item{default_dataset}{(optional) default dataset for any table references in
\code{query}, either as a string in the format used by BigQuery or as a
list with \code{project_id} and \code{dataset_id} entries}

\item{create_disposition}{behavior for table creation.
defaults to \code{"CREATE_IF_NEEDED"},
the only other supported value is \code{"CREATE_NEVER"}; see
\href{https://cloud.google.com/bigquery/docs/reference/v2/jobs#configuration.query.createDisposition}{the API documentation}
for more information}

\item{write_disposition}{behavior for writing data.
defaults to \code{"WRITE_EMPTY"}, other possible values are
\code{"WRITE_TRUNCATE"} and \code{"WRITE_APPEND"}; see
\href{https://cloud.google.com/bigquery/docs/reference/v2/jobs#configuration.query.writeDisposition}{the API documentation}
for more information}

\item{use_legacy_sql}{(optional) set to \code{FALSE} to enable BigQuery's standard SQL.}

\item{...}{Additional arguments merged into the body of the
request. \code{snake_case} will automatically be converted into
\code{camelCase} so you can use consistent argument names.}
}
\value{
a job resource list, as documented at
\url{https://developers.google.com/bigquery/docs/reference/v2/jobs}
}
\description{
This is a low-level function that creates a query job. To wait until it is
finished and then retrieve the results, see \code{\link[=query_exec]{query_exec()}}
}
\seealso{
API documentation for insert method:
\url{https://developers.google.com/bigquery/docs/reference/v2/jobs/insert}

Other jobs: \code{\link{get_job}},
  \code{\link{insert_extract_job}},
  \code{\link{insert_upload_job}}, \code{\link{wait_for}}
}
