% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteorological_variables.r
\name{dew.point}
\alias{dew.point}
\title{Dew Point}
\usage{
dew.point(
  Tair,
  VPD,
  accuracy = 0.001,
  Esat.formula = c("Sonntag_1990", "Alduchov_1996", "Allen_1998"),
  constants = bigleaf.constants()
)
}
\arguments{
\item{Tair}{Air temperature (degC)}

\item{VPD}{Vapor pressure deficit (kPa)}

\item{accuracy}{Accuracy of the result (deg C)}

\item{Esat.formula}{Optional: formula to be used for the calculation of esat and the slope of esat.
One of \code{"Sonntag_1990"} (Default), \code{"Alduchov_1996"}, or \code{"Allen_1998"}.
See \code{\link{Esat.slope}}.}

\item{constants}{Pa2kPa - conversion pascal (Pa) to kilopascal (kPa)}
}
\value{
\item{Td -}{dew point temperature (degC)}
}
\description{
calculates the dew point, the temperature to which air must be 
             cooled to become saturated (i.e. e = Esat(Td))
}
\details{
Dew point temperature (Td) is defined by:

          \deqn{e = Esat(Td)}
   
         where e is vapor pressure of the air and Esat is the vapor pressure deficit.
         This equation is solved for Td using \code{\link[stats]{optimize}}.
}
\examples{
dew.point(c(25,30),1.5)                

}
\references{
Monteith J.L., Unsworth M.H., 2008: Principles of Environmental Physics.
            3rd edition. Academic Press, London.
}
