% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteorological_variables.r
\name{kinematic.viscosity}
\alias{kinematic.viscosity}
\title{Kinematic Viscosity of Air}
\usage{
kinematic.viscosity(Tair, pressure, constants = bigleaf.constants())
}
\arguments{
\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{constants}{Kelvin - conversion degree Celsius to Kelvin \cr
pressure0 - reference atmospheric pressure at sea level (Pa) \cr
Tair0 - reference air temperature (K) \cr
kPa2Pa - conversion kilopascal (kPa) to pascal (Pa)}
}
\value{
\item{v -}{kinematic viscosity of air (m2 s-1)}
}
\description{
calculates the kinematic viscosity of air.
}
\details{
where v is the kinematic viscosity of the air (m2 s-1), 
         given by (Massman 1999b):
         
           \deqn{v = 1.327 * 10^-5(pressure0/pressure)(Tair/Tair0)^1.81}
}
\examples{
kinematic.viscosity(25,100)    

}
\references{
Massman, W.J., 1999b: Molecular diffusivities of Hg vapor in air, 
            O2 and N2 near STP and the kinematic viscosity and thermal diffusivity
            of air near STP. Atmospheric Environment 33, 453-457.
}
