% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evapotranspiration.r
\name{equilibrium.imposed.ET}
\alias{equilibrium.imposed.ET}
\title{Equilibrium and Imposed Evapotranspiration}
\usage{
equilibrium.imposed.ET(data, Tair = "Tair", pressure = "pressure",
  VPD = "VPD", Gs = "Gs", Rn = "Rn", G = NULL, S = NULL,
  missing.G.as.NA = FALSE, missing.S.as.NA = FALSE,
  constants = bigleaf.constants())
}
\arguments{
\item{data}{Data.frame or matrix containing all required input variables}

\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{VPD}{Air vapor pressure deficit (kPa)}

\item{Gs}{surface conductance (m s-1)}

\item{Rn}{Net radiation (W m-2)}

\item{G}{Ground heat flux (W m-2); optional}

\item{S}{Sum of all storage fluxes (W m-2); optional}

\item{missing.G.as.NA}{if \code{TRUE}, missing G are treated as \code{NA}s, otherwise set to 0.}

\item{missing.S.as.NA}{if \code{TRUE}, missing S are treated as \code{NA}s, otherwise set to 0.}

\item{constants}{cp - specific heat of air for constant pressure (J K-1 kg-1) \cr
eps - ratio of the molecular weight of water vapor to dry air (-)}
}
\value{
A data.frame with the following columns:
        \item{ET_eq}{Equilibrium ET (kg m-2 s-1)}
        \item{ET_imp}{Imposed ET (kg m-2 s-1)}
        \item{LE_eq}{Equilibrium LE (W m-2)}
        \item{LE_imp}{Imposed LE (W m-2)}
}
\description{
Evapotranspiration (ET) split up into imposed ET and equilibrium ET.
}
\details{
Total evapotranspiration can be written in the form (Jarvis & McNaughton 1986):

           \deqn{ET = \Omega ET_eq + (1 - \Omega)ET_imp}
         
         where \eqn{\Omega} is the decoupling coefficient as calculated from
         \code{\link{decoupling}}. \code{ET_eq} is the equilibrium evapotranspiration rate,
         the ET rate that would occur under uncoupled conditions, where the heat budget
         is dominated by radiation (when Ga -> 0):
         
           \deqn{ET_eq = (\Delta * (Rn - G - S) * \lambda) / (\Delta + \gamma)}
         
         where \eqn{\Delta} is the slope of the saturation vapor pressure curve (kPa K-1),
         \eqn{\lambda} is the latent heat of vaporization (J kg-1), and \eqn{\gamma}
         is the psychrometric constant (kPa K-1).
         \code{ET_imp} is the imposed evapotranspiration rate, the ET rate
         that would occur under fully coupled conditions (when Ga -> inf):
         
           \deqn{ET_imp = (\rho * cp * VPD * Gs * \lambda) / \gamma}
         
         where \eqn{\rho} is the air density (kg m-3).
}
\note{
Surface conductance (Gs) can be calculated with \code{\link{surface.conductance}}.
      Aerodynamic conductance (Ga) can be calculated using \code{\link{aerodynamic.conductance}}.
}
\examples{
df <- data.frame(Tair=20,pressure=100,VPD=seq(0.5,4,0.5),
                 Gs=seq(0.01,0.002,length.out=8),Rn=seq(50,400,50))            
equilibrium.imposed.ET(df)            
            
}
\references{
Jarvis P.G., McNaughton K.G., 1986: Stomatal control of transpiration:
            scaling up from leaf to region. Advances in Ecological Research 15, 1-49.
            
            Monteith J.L., Unsworth M.H., 2008: Principles of Environmental Physics.
            3rd edition. Academic Press, London.
}
\seealso{
\code{\link{decoupling}}
}
