% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_main.R
\name{bdm.labels}
\alias{bdm.labels}
\title{Get data-point clustering labels.}
\usage{
bdm.labels(bdm, merged = T, layer = 1)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()}.}

\item{merged}{A logical value. If TRUE (default value) and the \var{bdm} has been merged, the data-point labelling indicate the number of the merged clusters. If \var{merged} is set to FALSE or the \var{bdm} has not been merged the data-point labels correspond to the top-level clustering.}

\item{layer}{The number of the t-SNE layer (1 by default).}
}
\value{
A vector of data-point clustering labels.
}
\description{
Given that clusters are computed at grid-cell level, this function returns the clustering label for each data-point.
}
\examples{

bdm.example()
exMap.labels <- bdm.labels(exMap)
}
