% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hindex.R
\name{Hindex}
\alias{Hindex}
\title{h-index calculation}
\usage{
Hindex(M, authors, sep = ";", years = 10)
}
\arguments{
\item{M}{is a bibliographic data frame obtained by the converting function \code{\link{convert2df}}.
It is a data matrix with cases corresponding to manuscripts and variables to Field Tag in the original SCOPUS and Thomson Reuters' ISI Web of Knowledge file.}

\item{authors}{is a character vector. It contains the the authors' names list for which you want to calculate the H-index. The aurgument has the form C("SURNAME1 N","SURNAME2 N",...), in other words, for each author: surname and initials separated by one blank space. 
i.e for the auhtors SEMPRONIO TIZIO CAIO and ARIA MASSIMO \code{authors} argument is \code{authors = c("SEMPRONIO TC", "ARIA M")}.}

\item{sep}{is the field separator character. This character separates auhtors in each string of AU column of the bibiographic data frame. The default is \code{sep = ";"}.}

\item{years}{is a integer. It indicates the number of years to consider for Hindex calculation. Default is 10.}
}
\value{
an object of \code{class} "list". It contains two elements: H is a data frame with h-index, g-index and m-index for each author; CitationList is a list with the bibliographic collection for each author.
}
\description{
It calculates the authors' h-index and its variants.
}
\examples{

### EXAMPLE 1: ###
 
data(scientometrics)

authors <- c("SMALL H", "CHEN DZ")

Hindex(scientometrics, authors, sep = ";")$H

### EXAMPLE 2: Garfield h-index###
 
data(garfield)

indices=Hindex(garfield, authors="GARFIELD E", sep = ";")

# h-index, g-index and m-index of Eugene Garfield
indices$H

# Papers and total citations
indices$CitationList[[1]]

}
\seealso{
\code{\link{convert2df}} to import and convert an ISI or SCOPUS Export file in a bibliographic data frame.

\code{\link{biblioAnalysis}} function for bibliometric analysis.

\code{\link{summary}} to obtain a summary of the results.

\code{\link{plot}} to draw some useful plots of the results.
}
