% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkPlot.R
\name{networkPlot}
\alias{networkPlot}
\title{Plotting Bibliographic networks}
\usage{
networkPlot(NetMatrix, n = NULL, Degree = NULL, Title = "Plot",
  type = "kamada", label = TRUE, labelsize = 1, halo = FALSE,
  cluster = "walktrap", vos.path = NULL, size = FALSE, curved = FALSE,
  noloops = TRUE, remove.multiple = TRUE, remove.isolates = FALSE,
  weighted = NULL, edgesize = 1)
}
\arguments{
\item{NetMatrix}{is a network matrix obtained by the function \code{\link{biblioNetwork}}.}

\item{n}{is an integer. It indicates the number of vertices to plot.}

\item{Degree}{is an integer. It idicates the min frequency of a vertex. If Degree is not NULL, n is ignored.}

\item{Title}{is a character indicating the plot title.}

\item{type}{is a character object. It indicates the network map layout:

\tabular{lll}{
\code{type="circle"}\tab   \tab Circle layout\cr
\code{type="sphere"}\tab   \tab Sphere layout\cr
\code{type="mds"}\tab   \tab Multidimensional Scaling layout\cr
\code{type="fruchterman"}\tab   \tab Fruchterman-Reingold layout\cr
\code{type="kamada"}\tab   \tab  Kamada-Kawai layout\cr
\code{type="vosviewer"}\tab   \tab Network is plotted using VOSviewer software\cr}}

\item{label}{is logical. If TRUE vertex labels are plotted.}

\item{labelsize}{is an integer. It indicates the label size in the plot. Default is \code{labelsize=1}}

\item{halo}{is logical. If TRUE communities are plotted using different colors. Default is \code{halo=FALSE}}

\item{cluster}{is a character. It indicates the type of cluster to perform among ("null", optimal", "lovain","infomap","edge_betweenness","walktrap").}

\item{vos.path}{is a character indicating the full path whre VOSviewer.jar is located.}

\item{size}{is logical. If TRUE the point size of each vertex is proportional to its degree.}

\item{curved}{is a logical. If TRUE edges are plotted with an optimal curvature. Default is \code{curved=FALSE}}

\item{noloops}{is logical. If TRUE loops in the network are deleted.}

\item{remove.multiple}{is logical. If TRUE multiple links are plotted using just one edge.}

\item{remove.isolates}{is logical. If TRUE isolates vertices are not plotted.}

\item{weighted}{This argument specifies whether to create a weighted graph from an adjacency matrix. 
If it is NULL then an unweighted graph is created and the elements of the adjacency matrix gives the number of edges between the vertices. 
If it is a character constant then for every non-zero matrix entry an edge is created and the value of the entry is added as an edge attribute 
named by the weighted argument. If it is TRUE then a weighted graph is created and the name of the edge attribute will be weight.}

\item{edgesize}{is an integer. It indicates the network edge size.}
}
\value{
It is a network object of the class \code{igraph}.
}
\description{
\code{networkPlot} plots a bibliographic network.
}
\details{
The function \code{\link{networkPlot}} can plot a bibliographic network previously created by \code{\link{biblioNetwork}}.
The network map can be plotted using internal R routines or using \href{http://www.vosviewer.com/}{VOSviewer} by Nees Jan van Eck and Ludo Waltman.
}
\examples{
# EXAMPLE Co-citation network

data(scientometrics)

NetMatrix <- biblioNetwork(scientometrics, analysis = "co-citation", 
network = "references", sep = ";")

net <- networkPlot(NetMatrix, n = 20, type = "kamada", Title = "Co-Citation")

}
\seealso{
\code{\link{biblioNetwork}} to compute a bibliographic network.

\code{\link{cocMatrix}} to compute a co-occurrence matrix.

\code{\link{biblioAnalysis}} to perform a bibliometric analysis.
}
