% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-methods-beta-mc.R
\name{print.betamc}
\alias{print.betamc}
\title{Print Method for an Object of Class
\code{betamc}}
\usage{
\method{print}{betamc}(x, alpha = c(0.05, 0.01, 0.001), digits = 4, ...)
}
\arguments{
\item{x}{Object of Class \code{betamc},
that is,
the output of the
\code{BetaMC()},
\code{RSqMC()},
\code{SCorMC()},
\code{DeltaRSqMC()},
\code{PCorMC()}, or
\code{DiffBetaMC()}
functions.}

\item{alpha}{Significance level.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Prints a matrix of
estimates,
standard errors,
number of Monte Carlo replications,
and
confidence intervals.
}
\description{
Print Method for an Object of Class
\code{betamc}
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate the sampling distribution of parameter estimates
# (use a large R, for example, R = 20000 for actual research)
mc <- MC(object, R = 100)
# Generate confidence intervals for standardized regression slopes
std <- BetaMC(mc)
# Method ---------------------------------------------------------
print(std)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
