% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestNormalize.R
\name{bestNormalize}
\alias{bestNormalize}
\alias{predict.bestNormalize}
\alias{predict.bestNormalize}
\alias{print.bestNormalize}
\title{Calculate and perform best normalizing transformation}
\usage{
bestNormalize(x, allow_orderNorm = TRUE)

\method{predict}{bestNormalize}(object, newdata = NULL, inverse = FALSE,
  ...)

\method{print}{bestNormalize}(x, ...)
}
\arguments{
\item{x}{A vector to normalize}

\item{allow_orderNorm}{set to FALSE if orderNorm should not be applied}

\item{object}{an object of class 'bestNormalize'}

\item{newdata}{a vector of data to be (reverse) transformed}

\item{inverse}{if TRUE, performs reverse transformation}

\item{...}{additional arguments}
}
\value{
A list of class \code{bestNormalize} with elements 

\item{x.t}{transformed original data} 
\item{x}{original data} 
\item{norm_stats}{Pearson's Pearson's P / degrees of freedom}
\item{chosen_transform}{info about the transformation (of appropriate class)}

The \code{predict} function returns the numeric value of the transformation
performed on new data, and allows for the inverse transformation as well.
}
\description{
Performs a suite of normalizing transformations, and selects the
  best one on the basis of the Pearson P test statistic for normality. The 
  transformation that has the lowest P (calculated on the transformed data) 
  is selected. See details for more information.
}
\details{
\code{bestNormalize} estimates the optimal normalizing 
  transformation. This transformation can be performed on new data, and 
  inverted, via the \code{predict} function.

This function currently estimates the Yeo-Johnson transformation,
  the Box Cox transformation (if the data is positive), and the Lambert WxF
  Gaussianizing transformation of type "s". If allow_orderNorm == TRUE, then
  the ordered quantile normalization technique is also employed, and will
  likely be chosen if ties are not present since it essentially forces the
  data to follow a normal distribution. More information on the orderNorm
  technique can be found in the package vignette, or using \code{?orderNorm}.
  
NOTE: Only the Lambert technique of type = "s" (skew) ensures that the
transformation is consistently 1-1, so it is the only method currently used
in \code{bestNormalize()}. Use type = "h" or type = 'hh' at risk of not
having this estimate 1-1 transform. These alternative types are effective
when the data has exceptionally heavy tails, e.g. the Cauchy distribution.
}
\examples{

x <- rgamma(100, 1, 1)

BN_obj <- bestNormalize(x)
BN_obj
p <- predict(BN_obj)
x2 <- predict(BN_obj, newdata = p, inverse = TRUE)

all.equal(x2, x)

}
\seealso{
\code{\link[bestNormalize]{boxcox}},
 \code{\link{lambert}}, 
 \code{\link{orderNorm}},
 \code{\link{yeojohnson}}
}
