% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_past.R
\name{plot_past}
\alias{plot_past}
\title{Plot past results}
\usage{
plot_past(test_group = c("prog", "matrix_fun", "matrix_cal", "read", "write"),
  byte_optimize = NULL, blas_optimize = NULL, log = "y")
}
\arguments{
\item{test_group}{One of "prog", "matrix_fun", "matrix_cal", "read", "write". Default it \code{prog}.}

\item{byte_optimize}{Default \code{NULL}. The default behaviour is to plot all results.
To plot only the byte optimized results, set to \code{TRUE}, otherwise \code{FALSE}.}

\item{blas_optimize}{Default \code{NULL}. The default behaviour is to plot all results.
To plot only the BLASS optimized results, set to \code{TRUE}, otherwise \code{FALSE}.}

\item{log}{By default the y axis is plotted on the log scale. To change, set the 
the argument equal to the empty parameter string, \code{""}.}
}
\description{
Plot the previous benchmarks. This function creates two figures.
\itemize{
\item Figure 1: Total benchmark time over all benchmarks (in seconds) on the y-axis.
\item Figure 2: Relative time (compared to the smallest benchmark).
}
The data set used is \code{data(past_results)}.
}
\examples{
## Plot non byte optimize code
plot_past(byte_optimize=FALSE)
}

