#' Creates the site model's XML for the tracelog section
#' @inheritParams default_params_doc
#' @return lines of XML text
#' @seealso all site models' tracelog section is created
#'   by \code{\link{site_models_to_xml_tracelog}}
#' @examples
#' check_empty_beautier_folder()
#'
#' # <logger id="tracelog" ...>
#' #'   # Here
#' # </logger>
#'
#' check_empty_beautier_folder()
#' @author Richèl J.C. Bilderbeek
#' @export
site_model_to_xml_tracelog <- function(
  site_model
) {
  testit::assert(beautier::is_site_model(site_model))
  id <- site_model$id

  text <- NULL
  if (beautier::is_hky_site_model(site_model)) {
    text <- c(text, paste0("<log idref=\"kappa.s:", id, "\"/>")) # nolint this is no absolute path
  } else if (beautier::is_tn93_site_model(site_model)) {
    if (site_model$kappa_1_param$estimate == TRUE) {
      text <- c(text, paste0("<log idref=\"kappa1.s:", id, "\"/>")) # nolint this is no absolute path
    }
    if (site_model$kappa_2_param$estimate == TRUE) {
      text <- c(text, paste0("<log idref=\"kappa2.s:", id, "\"/>")) # nolint this is no absolute path
    }
  } else if (beautier::is_gtr_site_model(site_model)) {
    if (site_model$rate_ac_param$estimate == TRUE) {
      text <- c(text, paste0("<log idref=\"rateAC.s:", id, "\"/>")) # nolint this is no absolute path
    }
    if (site_model$rate_ag_param$estimate == TRUE) {
      text <- c(text, paste0("<log idref=\"rateAG.s:", id, "\"/>")) # nolint this is no absolute path
    }
    if (site_model$rate_at_param$estimate == TRUE) {
      text <- c(text, paste0("<log idref=\"rateAT.s:", id, "\"/>")) # nolint this is no absolute path
    }
    if (site_model$rate_cg_param$estimate == TRUE) {
      text <- c(text, paste0("<log idref=\"rateCG.s:", id, "\"/>")) # nolint this is no absolute path
    }
    if (site_model$rate_gt_param$estimate == TRUE) {
      text <- c(text, paste0("<log idref=\"rateGT.s:", id, "\"/>")) # nolint this is no absolute path
    }
  }
  if (!beautier::is_jc69_site_model(site_model)) {
    text <- c(text, paste0("<log idref=\"freqParameter.s:", id, "\"/>")) # nolint this is no absolute path
  }
  if (site_model$gamma_site_model$gamma_cat_count > 1) {
    text <- c(text, paste0("<log idref=\"gammaShape.s:", id, "\"/>")) # nolint this is no absolute path
  }
  text
}
