% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_site_model.R
\name{create_jc69_site_model}
\alias{create_jc69_site_model}
\alias{create_site_model_jc69}
\title{Create a JC69 site model}
\usage{
create_jc69_site_model(id = NA, gamma_site_model = create_gamma_site_model())
}
\arguments{
\item{id}{the IDs of the alignment (can be extracted from
the FASTA filename using \code{\link{get_alignment_id}})}

\item{gamma_site_model}{a gamma site model, as created
by \code{\link{create_gamma_site_model}}}
}
\value{
a JC69 site_model
}
\description{
Create a JC69 site model
}
\examples{
check_empty_beautier_folder()

jc69_site_model <- create_jc69_site_model()

output_filename <- get_beautier_tempfilename()
create_beast2_input_file(
  input_filename = get_fasta_filename(),
  output_filename = output_filename,
  site_model = jc69_site_model
)
file.remove(output_filename)

remove_beautier_folder()
check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
