% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_treelog_xml.R
\name{create_treelog_xml}
\alias{create_treelog_xml}
\title{Creates the XML text for the `logger` tag with ID `treelog`.
This section has these elements:
```
<logger id="treelog.t:test_output_0" spec="Logger" fileName="my_treelog.trees" logEvery="345000" mode="tree" sanitiseHeaders="true" sort="smart"> # nolint indeed long
    <log id="TreeWithMetaDataLogger.t:test_output_0" spec="beast.evolution.tree.TreeWithMetaDataLogger" tree="@Tree.t:test_output_0"/> # nolint indeed long
</logger>
```}
\usage{
create_treelog_xml(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
lines of XML text
}
\description{
Creates the XML text for the `logger` tag with ID `treelog`.
This section has these elements:
```
<logger id="treelog.t:test_output_0" spec="Logger" fileName="my_treelog.trees" logEvery="345000" mode="tree" sanitiseHeaders="true" sort="smart"> # nolint indeed long
    <log id="TreeWithMetaDataLogger.t:test_output_0" spec="beast.evolution.tree.TreeWithMetaDataLogger" tree="@Tree.t:test_output_0"/> # nolint indeed long
</logger>
```
}
\author{
Richèl J.C. Bilderbeek
}
