% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beanz_present.R
\name{comp.stan}
\alias{comp.stan}
\alias{r.forest.comp}
\alias{r.plot.comp}
\alias{r.summary.comp}
\title{Comparison of posterior treatment effects}
\usage{
r.summary.comp(stan.rst, sel.grps = NULL, cut = 0, digits = 3)

r.plot.comp(stan.rst, sel.grps = NULL, ...)

r.forest.comp(stan.rst, sel.grps = NULL, ..., quants = c(0.025, 0.975))
}
\arguments{
\item{stan.rst}{a class \code{beanz.stan} object generated by
\code{\link{call.stan}}}

\item{sel.grps}{an array of subgroup numbers to be included in the summary results}

\item{cut}{cut point to compute the probabiliby that the posterior subgroup
treatment effects is below}

\item{digits}{number of digits in the summary result table}

\item{...}{options for \code{plot} function}

\item{quants}{lower and upper quantiles of the credible intervals in the
forest plot}
}
\value{
\code{r.summary.comp} generates a data frame with summary statistics
    of the difference of treatment effects between the selected subgroups.
    \code{r.plot.comp} generates the density plot of the difference in the
    posterior treatment effects between subgroups. \code{r.forest.comp}
    generates the forest plot of the difference in the posterior treatment
    effects between subgroups.
}
\description{
Present the difference in the posterior treatment effects
between subgroups
}
\examples{

var.cov    <- c("sodium", "lvef", "any.vasodilator.use");
var.resp   <- "y";
var.trt    <- "trt";
var.censor <- "censor";
resptype   <- "survival";
var.estvar <- c("Estimate", "Variance");

subgrp.effect <- r.get.subgrp.raw(solvd.sub,
                                  var.resp   = var.resp,
                                  var.trt    = var.trt,
                                  var.cov    = var.cov,
                                  var.censor = var.censor,
                                  resptype   = resptype);

rst.sr     <- call.stan("sr", dat.sub=subgrp.effect,
                        var.estvar=var.estvar, var.cov = var.cov,
                        lst.par.pri=list(vtau=1000, vgamma=1000, vrange=c(0,0)),
                        chains=1, iter=500,
                        warmup=100, thin=2, seed=1000);

sel.grps <- c(1,4,5);
tbl.sub <- r.summary.comp(rst.sr, sel.grps=sel.grps);
r.plot.stan(rst.sr, sel.grps = sel.grps);
r.forest.stan(rst.sr, sel.grps = sel.grps);


}
\seealso{
\code{\link{call.stan}}
}

