% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_space.R
\name{compute_model_space_stats}
\alias{compute_model_space_stats}
\title{Approximate standard deviations for the models}
\usage{
compute_model_space_stats(
  df,
  dep_var_col,
  timestamp_col,
  entity_col,
  params,
  exact_value = FALSE,
  model_prior = "uniform",
  cl = NULL
)
}
\arguments{
\item{df}{Data frame with data for the SEM analysis.}

\item{dep_var_col}{Column with the dependent variable}

\item{timestamp_col}{The name of the column with timestamps}

\item{entity_col}{Column with entities (e.g. countries)}

\item{params}{A matrix (with named rows) with each column corresponding
to a model. Each column specifies model parameters. Compare with
\link[bdsm]{optim_model_space_params}}

\item{exact_value}{Whether the exact value of the likelihood should be
computed (\code{TRUE}) or just the proportional part (\code{FALSE}). Check
\link[bdsm]{sem_likelihood} for details.}

\item{model_prior}{Which model prior to use. For now there are two options:
\code{'uniform'} and \code{'binomial-beta'}. Default is \code{'uniform'}.}

\item{cl}{An optional cluster object. If supplied, the function will use this
cluster for parallel processing. If \code{NULL} (the default),
\code{pbapply::pblapply} will run sequentially.}
}
\value{
Matrix with columns describing likelihood and standard deviations for each
model. The first row is the likelihood for the model (computed using the
parameters in the provided model space). The second row is almost 1/2 * BIC_k
as in Raftery's Bayesian Model Selection in Social Research eq. 19 (see TODO
in the code below). The third row is model posterior probability. Then there
are rows with standard deviations for each parameter. After that we have rows
with robust standard deviation (not sure yet what exactly "robust" means).
}
\description{
Approximate standard deviations are computed for the models in the given
model space. Two versions are computed.
}
\examples{
\donttest{
 library(magrittr)
 data_prepared <- bdsm::economic_growth[, 1:6] \%>\%
   bdsm::feature_standardization(
     excluded_cols = c(country, year, gdp)
   ) \%>\%
   bdsm::feature_standardization(
     group_by_col  = year,
     excluded_cols = country,
     scale         = FALSE
   )

 compute_model_space_stats(
   df            = data_prepared,
   dep_var_col   = gdp,
   timestamp_col = year,
   entity_col    = country,
   params        = small_model_space$params
 )
}

}
