% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_checks.R
\name{spatial_resolution}
\alias{spatial_resolution}
\title{Clean data based on spatial resolution}
\usage{
spatial_resolution(bddata, res = 100)
}
\arguments{
\item{bddata}{Bio diversity data in a data frame}

\item{res}{The highest coordinate uncertainty required}
}
\description{
Clean data based on spatial resolution
}
\section{samplePassData}{

When resolution is 100 meters, Coordinate Uncertainties below 100 meters will pass.
}

\section{sampleFailData}{

When resolution is 100 meters, Coordinate Uncertainties above 100 meters will fail.
}

\section{targetDWCField}{

coordinateUncertaintyInMeters
}

\section{checkCategory}{

spatial
}

\examples{

if(interactive()){

library(rgbif)
occdat <- occ_data(
  country = 'AU', # Country code for australia
  classKey = 359, # Class code for mammalia
  limit = 50 # Get only 50 records
)
myData <- occdat$data

responses <- spatial_resolution(myData, 1500)

}

}
