% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{posterior.GaussianNIG}
\alias{posterior.GaussianNIG}
\title{Update a "GaussianNIG" object with sample sufficient statistics}
\usage{
\method{posterior}{GaussianNIG}(obj, ss, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{ss}{Sufficient statistics of (x,X). In Gaussian-NIG case the sufficient statistic of sample (x,X) is a object of type "ssGaussianLinear", it can be  generated by the function sufficientStatistics().}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the gamma stored in "obj" will be updated based on "ss".
}
\description{
For the model structure:
   \deqn{x \sim Gaussian(X beta,sigma^2)}
   \deqn{sigma^2 \sim InvGamma(a,b)}
   \deqn{beta \sim Gaussian(m,sigma^2 V)}
Where X is a row vector, or a design matrix where each row is an obervation. InvGamma() is the Inverse-Gamma distribution, Gaussian() is the Gaussian distribution. See \code{?dInvGamma} and \code{dGaussian} for the definitions of these distribution.\cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
Update (m,V,a,b) by adding the information of newly observed samples (x,X). The model structure and prior parameters are stored in a "GaussianNIG" object, the prior parameters in this object will be updated after running this function.
}
\examples{
obj <- GaussianNIG(gamma=list(m=0,V=1,a=1,b=0))
X <- 1:20
x <- rnorm(20)+ X*0.3
ss <- sufficientStatistics(obj = obj,X=X,x=x)
posterior(obj = obj,ss = ss)
obj
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Downloaded from http://www. biostat. umn. edu/~ph7440 (2008).
}
\seealso{
\code{\link{GaussianNIG}},\code{\link{posteriorDiscard.GaussianNIG}},\code{\link{sufficientStatistics.GaussianNIG}}
}
