% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{MPE.LinearGaussianGaussian}
\alias{MPE.LinearGaussianGaussian}
\title{Mean Posterior Estimate (MPE) of a "LinearGaussianGaussian" object}
\usage{
\method{MPE}{LinearGaussianGaussian}(obj, ...)
}
\arguments{
\item{obj}{A "LinearGaussianGaussian" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric vector, the MPE estimate of "z".
}
\description{
Generate the MPE estimate of mu in following model structure:
     \deqn{x \sim Gaussian(A z + b, Sigma)}
     \deqn{z \sim Gaussian(m,S)}
Where Sigma is known. A is a \eqn{dimx x dimz} matrix, x is a \eqn{dimx x 1} random vector, z is a \eqn{dimz x 1} random vector, b is a \eqn{dimm x 1} vector. Gaussian() is the Gaussian distribution. See \code{?dGaussian} for the definition of Gaussian distribution.\cr
The model structure and prior parameters are stored in a "LinearGaussianGaussian" object. \cr
The MPE estimates is:
\itemize{
  \item z_MPE = E(z|m,S,A,b,x,Sigma)
}
}
\examples{
obj <- LinearGaussianGaussian(gamma=list(Sigma=matrix(c(2,1,1,2),2,2),
                                         m=c(0.2,0.5,0.6),S=diag(3)))
x <- rGaussian(100,mu = runif(2),Sigma = diag(2))
A <- matrix(runif(6),2,3)
b <- runif(2)
ss <- sufficientStatistics(obj,x=x,A=A,b=b)
## update prior into posterior
posterior(obj=obj,ss=ss)
## get the MAP estimate of z
MPE(obj)
}
\references{
Murphy, Kevin P. Machine learning: a probabilistic perspective. MIT press, 2012.
}
\seealso{
\code{\link{LinearGaussianGaussian}}
}
