% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{MPE.GaussianInvWishart}
\alias{MPE.GaussianInvWishart}
\title{Mean Posterior Estimate (MPE) of a "GaussianInvWishart" object}
\usage{
\method{MPE}{GaussianInvWishart}(obj, ...)
}
\arguments{
\item{obj}{A "GaussianInvWishart" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
matrix, the MPE estimate of "Sigma".
}
\description{
Generate the MPE estimate of Sigma in following model structure:
    \deqn{x ~ Gaussian(mu,Sigma)}
    \deqn{Sigma ~ InvWishart(v,S)}
mu is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} and \code{?dInvWishart} for the definition of the distributions.\cr
The model structure and prior parameters are stored in a "GaussianInvWishart" object. \cr
The MPE estimates are:
\itemize{
  \item (Sigma_MPE) = E(Sigma|v,S,x,mu)
}
}
\examples{
obj <- GaussianInvWishart(gamma=list(mu=c(-1.5,1.5),v=3,S=diag(2)))
x <- rGaussian(100,mu = c(-1.5,1.5),Sigma = matrix(c(0.1,0.03,0.03,0.1),2,2))
ss <- sufficientStatistics(obj=obj,x=x,foreach = FALSE)
posterior(obj=obj,ss = ss)
MPE(obj)
}
\references{
Gelman, Andrew, et al. Bayesian data analysis. CRC press, 2013.

MARolA, K. V., JT KBNT, and J. M. Bibly. Multivariate analysis. AcadeInic Press, Londres, 1979.
}
\seealso{
\code{\link{GaussianInvWishart}}
}
