% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{posterior.DP}
\alias{posterior.DP}
\title{Update a "DP" object with sample sufficient statistics}
\usage{
\method{posterior}{DP}(obj, ss, z, w = NULL, ...)
}
\arguments{
\item{obj}{A "DP" object.}

\item{ss}{Sufficient statistics of x of the "BasicBayesian" object, must be a list of sufficient statistics for each of the observations. Use sufficientStatistics(...,foreach=TRUE) to generate ss. See examples.}

\item{z}{integer, the partition label of the parameter space where the observation x is drawn from.}

\item{w}{Sample weights, default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the model stored in "obj" will be updated based on "ss".
}
\description{
For the model structure: \cr
     pi|alpha ~ DP(alpha,U) \cr
     z|pi ~ Categorical(pi) \cr
     theta_z|psi ~ H0(psi) \cr
     x|theta_z,z ~ F(theta_z) \cr
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process. The choice of F() and H0() can be arbitrary, they are distributions of x and theta_z correspondingly. \cr
This function will update the prior knowledge by adding the information of newly observed samples x. The model structure and prior parameters are stored in a "DP" object, the prior parameters in this object will be updated after running this function.
}
\examples{
x <- rnorm(40)
z <- sample(1L:10L,size = 40,replace = TRUE)
obj <- DP()
ss <- sufficientStatistics(obj = obj,x=x,foreach = TRUE) #must use foreach=TRUE
for(i in 1L:length(z)) posterior(obj = obj,ss = ss[[i]],z=z[i])
obj
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{DP}},\code{\link{posteriorDiscard.DP}},\code{\link{sufficientStatistics.DP}}
}
