% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{MPE.CatDirichlet}
\alias{MPE.CatDirichlet}
\title{MPE of a "CatDirichlet" object}
\usage{
\method{MPE}{CatDirichlet}(obj, ...)
}
\arguments{
\item{obj}{A "CatDirichlet" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector, the MPE of "pi".
}
\description{
Generate the MPE of "pi" in following Categorical-Dirichlet structure: \cr
     pi|alpha ~ Dirichlet(alpha) \cr
     x|pi ~ Categorical(pi) \cr
the model structure and prior parameters are stored in a "CatDirichlet" object. \cr
MPE is pi_MPE = E(pi|alpha,x), E() is the expectation function.
}
\examples{
obj <- CatDirichlet(gamma=list(alpha=rep(1,26),uniqueLabels = letters))
x <- sample(letters,size = 20,replace = TRUE)
w <- runif(20)
posterior(obj=obj,ss=x,w=w)
MPE(obj)
}
\references{
Murphy, Kevin P. Machine learning: a probabilistic perspective. MIT press, 2012.
}
\seealso{
\code{\link{CatDirichlet}}
}
