% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_Bes.R
\name{envelope_bes}
\alias{envelope_bes}
\title{envelope_bes}
\usage{
envelope_bes(
  residual,
  kap,
  lam,
  x,
  v,
  nsim_env,
  prob,
  n,
  epsilon,
  link.mean,
  link.precision
)
}
\arguments{
\item{residual}{character indicating the type of residual ("pearson", "score" or "quantile").}

\item{kap}{coefficients in kappa related to the mean parameter.}

\item{lam}{coefficients in lambda related to the precision parameter.}

\item{x}{matrix containing the covariates for the mean submodel. Each column is a different covariate.}

\item{v}{matrix containing the covariates for the precision submodel. Each column is a different covariate.}

\item{nsim_env}{number of synthetic data sets to be generated.}

\item{prob}{confidence level of the envelope (number between 0 and 1).}

\item{n}{sample size.}

\item{epsilon}{tolerance parameter used in the Expectation-Maximization algorithm applied to the synthetic data.}

\item{link.mean}{a string containing the link function for the mean.
The possible link functions for the mean are "logit","probit", "cauchit", "cloglog".}

\item{link.precision}{a string containing the link function the precision parameter.
The possible link functions for the precision parameter are "identity", "log", "sqrt", "1/precision^2", "inverse".}
}
\value{
Matrix with dimension 2 x n (1st row = upper bound, second row = lower bound).
}
\description{
Function to calculate envelopes based on residuals for the bessel regression.
}
