% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.bbl}
\alias{summary.bbl}
\title{Naive Bayes Summary}
\usage{
\method{summary}{bbl}(object, prior.count = 1, ...)
}
\arguments{
\item{object}{Object of class \code{bbl}}

\item{prior.count}{Prior count to be used for computing coefficients
and test results. If \code{0}, will produce \code{NA}s for
factor levels without data points.}

\item{...}{Other arguments to methods.}
}
\value{
Object of class \code{summary.bbl} extending \code{bbl} class;
a list with extra components
\item{h}{List of bias coefficients of response groups under naive
Bayes approximation}
\item{h0}{Bias coefficients of pooled group under naive Bayes}
\item{chisqNaive}{Vector of chi-square statistics for likelihood ratio test
for each predictor}
\item{dfNaive}{Vector of degrees of freedom for likelihood ratio test for
each predictor}
\item{pvNaive}{Vector p-values for each predictor}
}
\description{
Estimate significant of predictor-group association using naive Bayes model
}
\details{
This \code{summary.bbl} method gives a rough overview of associations
within a \code{bbl} fit object via naive Bayes coefficients and test
p-values. Note that naive Bayes results displayed ignore interactions
even when interactions are present in the model being displayed. This
feature is because simple analytic results exist for naive Bayes
coefficients and test p-values. The likelihood ratio test is with respect
to the null hypothesis that coefficients are identical for all response
groups.
}
