% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onb.R
\name{onb_metadata}
\alias{onb_metadata}
\title{Fetch Österreichische Nationalbank (OeNB) metadata}
\usage{
onb_metadata(hier_id, key, ..., lang = "en")
}
\arguments{
\item{hier_id}{(\code{integer(1)})\cr
Hierarchy id to query.}

\item{key}{(\code{character()})\cr
The series keys to query.}

\item{...}{(\code{any})\cr
Additional parameters to pass to the API.}

\item{lang}{(\code{character(1)})\cr
Language to query. Default \code{"en"}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested data.
}
\description{
Fetch Österreichische Nationalbank (OeNB) metadata
}
\examples{
\donttest{
onb_metadata(hier_id = 11, key = "VDBFKBSC217000")
}
}
\seealso{
Other metadata: 
\code{\link{bbk_metadata}()},
\code{\link{ecb_metadata}()},
\code{\link{onb_dimension}()},
\code{\link{onb_frequency}()},
\code{\link{onb_hierarchy}()},
\code{\link{onb_toc}()}
}
\concept{metadata}
