% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/almost.zero.R
\name{almost.zero}
\alias{almost.zero}
\title{Test if values of a vector are almost zero}
\usage{
almost.zero(x, tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{numeric. The vector of numeric values at stake.}

\item{tolerance}{numeric. Differences smaller than tolerance are considered as equal.
The default value is close to \code{1.5e-8}.}
}
\value{
A logical vector of the same length as \code{x}.
}
\description{
The function \code{almost.zero} tests if values of
the numeric vector \code{x} are equal to zero up 
to a tolerance.
}
\examples{
almost.zero(c(0, 10^(-7), 10^(-8)))

}
\seealso{
\code{\link[base]{all.equal}}.
}
