% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrGraphs_namePretty.R
\name{namePretty}
\alias{namePretty}
\title{Pretty Axis}
\usage{
namePretty(x, orientation = "table", order = "none", label.abbr = FALSE,
  offset = 0.5, style = "at")
}
\arguments{
\item{x}{the discrete data values.}

\item{orientation}{the orientation of the data in \code{x}.\cr \tabular{ll}{
"table" \tab first in sequence at top (ends on right if x-axis)\cr "grid"
\tab first in sequence at bottom \cr }}

\item{order}{the order of the data in \code{x}.\cr 
\tabular{ll}{ 
"none" \tab accept order as is\cr 
"ascending" \tab sort in ascending alphabetical order\cr
"descending" \tab sort in descending alphabetical order\cr 
named numeric vector \tab sort by values (largest value at top if orientation is
"table")\cr
character vector \tab specifies the sequence of names\cr }}

\item{label.abbr}{logical, if \code{TRUE}, then create abbreviations for \code{x},
otherwise use the full text of \code{x} for labels.}

\item{offset}{amount to offset the range, generally 0.5 or 1. The range of
the data is from 1 to the number of elements in \code{x}.}

\item{style}{character string indicating the placement of the ticks. If "at" (default),
then place ticks at the labels. If "between," then place ticks between the labels.}
}
\value{
Information about the axis labels
}
\description{
Constructs information for making a nicely formatted axis for discrete data.
A support function for creating discrete axes.
}
\details{
Added from smwrGraphs.
}
\keyword{dplot}
\keyword{internal}
