% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesfactor.R
\name{bayesfactor}
\alias{bayesfactor}
\title{Bayes Factors (BF)}
\usage{
bayesfactor(..., prior = NULL, direction = "two-sided",
  hypothesis = 0, effects = c("fixed", "random", "all"),
  verbose = TRUE, denominator = 1, match_models = FALSE,
  prior_odds = NULL)
}
\arguments{
\item{...}{A numeric vector, model object(s), or the output from \code{bayesfactor_models}.}

\item{prior}{Vector representing a prior distribution (if \code{posterior} is a vector), or a data frame with column names matching \code{posterior}'s (if \code{posterior} is a data frame). Otherwise ignored.}

\item{direction}{Test type. One of \code{0}, \code{"two-sided"} (default, two tailed),
\code{-1}, \code{"left"} (left tailed) or \code{1}, \code{"right"} (right tailed).}

\item{hypothesis}{Value to be tested against (usually \code{0} in the context of null hypothesis testing).}

\item{effects}{Should results for fixed effects, random effects or both be returned?
Only applies to mixed models. May be abbreviated.}

\item{verbose}{Toggle off warnings.}

\item{denominator}{Either an integer indicating which of the models to use as the denominator,
or a model to use as a denominator. Ignored for \code{BFBayesFactor}.}

\item{match_models}{If \code{FALSE} (default), Inclustion BFs are computed by
comparing all models with an effect against all models without the effect. If \code{TRUE},
Inclusion BFs are computed by comparing all models with an effect against models without
the effect AND without any higher-order interactions with the effect.}

\item{prior_odds}{optional vector of prior odds for the models. See \code{BayesFactor::priorOdds}}
}
\value{
Some type of Bayes factor, depending on the input. See \code{\link{bayesfactor_savagedickey}}, \code{\link{bayesfactor_models}} or \code{\link{bayesfactor_inclusion}}
}
\description{
This function compte the Bayes factors (BFs) that are appropriate to the input.
For vectors or single models, it will compute \code{\link[=bayesfactor_savagedickey]{Savage-Dickey's BFs}}. For multiple models, it will return the BF corresponding to \code{\link[=bayesfactor_models]{comparison between models}} and if a comparison is passed, it will compute the \code{\link[=bayesfactor_inclusion]{inclusion BF}}.
\cr\cr
For a complete overview of these functions, read the \href{https://easystats.github.io/bayestestR/articles/bayes_factors.html}{Bayes factor vignette}.
}
\examples{
library(bayestestR)

# Vectors
prior <- distribution_normal(1000, mean = 0, sd = 1)
posterior <- distribution_normal(1000, mean = .5, sd = .3)

bayesfactor(posterior, prior = prior)
\dontrun{
# rstanarm models
# ---------------
library(rstanarm)
model <- stan_lmer(extra ~ group + (1 | ID), data = sleep)
bayesfactor(model)
}

# Frequentist models
# ---------------
m0 <- lm(extra ~ 1, data = sleep)
m1 <- lm(extra ~ group, data = sleep)
m2 <- lm(extra ~ group + ID, data = sleep)

comparison <- bayesfactor(m0, m1, m2)
comparison

bayesfactor(comparison)
}
