% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesboot.R
\name{summary.bayesboot}
\alias{summary.bayesboot}
\title{Summarize the result of \code{bayesboot}}
\usage{
\method{summary}{bayesboot}(object, cred.mass = 0.95, ...)
}
\arguments{
\item{object}{The bayesboot object to summarize.}

\item{cred.mass}{The probability mass to include in the highest density intervals.}

\item{...}{Not used.}
}
\value{
A data frame with three columns: (1) \bold{statistic} the name of the
  statistic, (2) \bold{measure} the name of the summarizing measure, and (3)
  \bold{value} the value of the summarizing measure.
}
\description{
Summarizes the result of a call to \code{bayesboot} by calculating means, SDs,
highest density intervals and quantiles of the posterior marginals.
}
\seealso{
\code{\link[HDInterval]{hdi}} in the HDInterval package for directly calculating
  highest density intervals from \code{bayesboot} objects.
}

